%define module_name PerlIO-via-Limit
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Data/Inheritable.pm) perl(Exception/Class.pm) perl(ExtUtils/MakeMaker.pm) perl(PerlIO/via.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt2
Summary: PerlIO layer for length restrictions
Group: Development/Perl
License: perl
URL: https://github.com/hiroaki/PerlIO-via-Limit

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HW/HWAT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
PerlIO::via::Limit implements a PerlIO layer that restricts length of stream.

There is an important constraint, 
it is able to specify only one limit value within application 
because the 'length' is a class data.

The following example does not work as expected:

    PerlIO::via::Limit->length(256);
    open( my $fh1, "<:via(Limit)", $file1 );

    PerlIO::via::Limit->length(512);
    open( my $fh2, "<:via(Limit)", $file2 );

    local $/ = undef;
    my $data1 = <$fh1>; 
    my $data2 = <$fh2>; 

    CORE::length($data1); # is not 256 but 512
    CORE::length($data2); # is also 512

Therefore, it is necessary to divide namespace,
in order to use two or more limit values simultaneously.

    package Foo;
    use base PerlIO::via::Limit;
    
    package main;
    PerlIO::via::Limit->length(256);
    Foo->length(512);

    open( my $fh1, "<:via(Limit)", $file1 );
    open( my $fh2, "<:via(Foo)", $file2 );

    local $/ = undef;
    my $data1 = <$fh1>; 
    my $data2 = <$fh2>; 

    CORE::length($data1); # is 256
    CORE::length($data2); # is 512

Actually you do not have to code like the above,
instead, the create() method supports it by simple interface.

    my $limit256 = PerlIO::via::Limit->create(256);
    my $limit512 = PerlIO::via::Limit->create(512);

    open( my $fh1, "<:via($limit256)", $file1 );
    open( my $fh2, "<:via($limit100)", $file2 );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/P*

%changelog
