%define module_version 0.004
%define module_name PerlX-ArraySkip
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.004
Release: alt1
Summary: sub { shift; @_ }
Group: Development/Perl
License: unrestricted
URL: https://metacpan.org/release/PerlX-ArraySkip

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The `arrayskip' function returns the entire list it was passed as arguments,
except the first. This is an entirely trivial function and can be written as:

	sub arrayskip { shift; @_ }

The principle of TIMTOWTDI says that there are other ways of skipping the
first item in an array, but according to my benchmarking this performs best.

A good question is: why would you want to do this? Well, in Perl there are
two common function calling patterns, named parameters:

	give(
		giver     => $alice,
		recipient => $bob,
		gift      => $dinosaur,
	);

and positional parameters:

	give($alice, $bob, $dinosaur);

Positional parameters look fine when you've got one or two arguments, but
can start looking unwieldly with four or more. Let's imagine that our
`give' function takes a hypothetical fourth parameter, a boolean indicating
whether the gift had wrapping paper on:

	give($alice, $bob, $dinosaur, 1);

When we come back to that line a few weeks, we might be confused about
what it means. Is Bob giving Alice to the dinosaur once? The `arrayskip'
function allows you to add extra items into the parameter list which will
be skipped over, and can thus act as comments:

	give(
		arrayskip 'giver',     $alice,
		arrayskip 'recipient', $bob,
		arrayskip 'gift',      $dinosaur,
		arrayskip 'wrapped',   1,
	);

Now let's use a couple of tricks to make it even clearer. Firstly,
PerlX::ArraySkip allows you to import the `arrayskip' function with your
choice of name. You can call it something more suitable to your use case,
such as `arg'. Secondly, the fat comma.

	use PerlX::ArraySkip 'arg';
	
	give(
		arg giver     => $alice,
		arg recipient => $bob,
		arg gift      => $dinosaur,
		arg wrapped   => 1,
	);

While the arguments are still positional (you can't change their order) they
now have the appearance of named arguments, improving their readability, and
the code's ease of maintenance.

So, why should you use PerlX::ArraySkip instead of defining your own
`arrayskip' function? No reason at all. You can define your own function
in fewer keystrokes than loading this module. Observe:

	use PerlX::ArraySkip 'skip';
	sub skip { shift; @_ }

This module, while it does provide an implementation, is mostly just a place
to document the pattern. You could define your own function and include a
reference to this module as a comment:

	sub arg { shift; @_ } # see PerlX::ArraySkip

=begin trustme

=item `arrayskip'

=end trustme


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYRIGHT README LICENSE
%perl_vendor_privlib/P*

%changelog
