%define module_version 0.002
%define module_name PerlX-QuoteOperator-Inescapable
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/OptList.pm) perl(Devel/Declare.pm) perl(Devel/Declare/Context/Simple.pm) perl(ExtUtils/MakeMaker.pm) perl(Sub/Install.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: a quote-like operator with no string escapes
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/PerlX-QuoteOperator-Inescapable

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
PerlX::QuoteOperator::Inescapable introduces a quote-like operator like
`q(...)' but that supports no string escapes! All characters
quoted are treated literally.

Like other quote-like operators, standard left/right bracket pairs are
supported; but unlike other quote-like operators, you cannot nest balanced
pairs of brackets:

	Q(Hello (Earth) World);   # no!

By default, a single quote-like operator is defined, `Q'. You
can define alternative ones:

	use Path::Class;
	use PerlX::QuoteOperator::Inescapable
		Q => (),   # default Q operator
		F => sub ($) { Path::Class::File->new(@_) },
		D => sub ($) { Path::Class::Dir->new(@_) },
	;
	
	my $fonts = D!\\Server1\Marketing\Fonts!;


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README COPYRIGHT
%perl_vendor_privlib/P*

%changelog
