Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Perlilog
Version:        1.0
Release:        alt2_24
Summary:        Verilog environment and IP core handling in Perl
License:        GPL-2.0-or-later
URL:            https://metacpan.org/release/Perlilog
Source0:        https://cpan.metacpan.org/authors/id/B/BI/BILLAUER/Perlilog-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(strict.pm)
# Tests:
BuildRequires:  perl(Test.pm)





Source44: import.info
%filter_from_provides /^perl(PL_const.pm)/d
%filter_from_provides /perl(PL_hardroot.pm)/d
%filter_from_provides /perl(PL_settable.pm)/d
%filter_from_provides /perl(UNIVERSAL.pm)/d

%description
Perlilog is a command-line tool which generates Verilog
modules from a set of files, which come in several other
formats. It was originally designed to integrate Verilog IP cores.

%prep
%setup -q -n Perlilog-%{version}

# rpmlint : line endings
affected=`find examples/ -type f -name "*.*"`
for i in license.txt $affected ; do
  echo "Fixing wrong-file-end-of-line-encoding : $i"
  sed 's/\r//' $i > $i.rpmlint
  touch -r $i $i.rpmlint;
  mv $i.rpmlint $i
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference license.txt
%doc Changes examples/
%dir %{perl_vendor_privlib}/Perlilog
%{perl_vendor_privlib}/Perlilog/*
%{perl_vendor_privlib}/testclass.pl
%{perl_vendor_privlib}/Perlilog.pm

%changelog
