%define module_name Pg-BulkLoad
Epoch: 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBD/Pg.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(Data/Printer.pm) perl(ExtUtils/MakeMaker.pm) perl(Mojo/Pg.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Try/Tiny.pm) perl(feature.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.07
Release: alt1
Summary: Bulk Load for Postgres with ability to skip bad records.
Group: Development/Perl
License: gpl
URL: https://github.com/brainbuz/pgbulkload

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRAINBUZ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Shell> split -l 50000 -a 3 -d mydata.csv load
 Shell> myloadscript.pl load*

 === myloadscript.pl ===

 use Pg::BulkCopy;

 my %%args = (
_dbname => 'pgbulkcopy',
_dbhost => 'localhost',
_dbuser => 'postgres',
_dbpass => 'postgres',
_errorfile => '/tmp/pgbulk.error',
_errorlimit => 500,
_);

 my $pgc = Pg::BulkLoad->new(  %%args );

 .... # your code to read file names and possibly manipulate files contents prior to load.

 while ( @filelist ) {
     $pgc->load( $file, $_, 'csv' );
 }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/P*

%changelog
