%define module_name Pg-SQL-PrettyPrinter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(Encode.pm) perl(HTTP/Tiny.pm) perl(JSON/MaybeXS.pm) perl(Module/Build.pm) perl(Module/Runtime.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/PerlTidy.pm) perl(Unicode/Collate.pm) perl(Unicode/Normalize.pm) perl(autodie.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9
Release: alt1
Summary: Pretty printer for SQL queries
Group: Development/Perl
License: bsd
URL: https://gitlab.com/depesz/pg-sql-prettyprinter

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DE/DEPESZ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Formats SQL queries "nicely". To do so it first has to parse it, and for this
it's using microservice available over HTTP:
https://gitlab.com/depesz/pg-query-parser-microservice.

Usage example:

    use Pg::SQL::PrettyPrinter;

    my $pp = Pg::SQL::PrettyPrinter->new(
        'service' => 'http://127.0.0.1:15283/',
        'sql' => 'select 1'
    );

    my $nice = $pp->pretty_print();

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes TODO README LICENSE
%perl_vendor_privlib/P*

%changelog
