%define module_name Pherkin-Extension-Weasel
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp/Always.pm) perl(Data/Perl/Role/Collection/Array.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find/Rule.pm) perl(File/Share.pm) perl(File/ShareDir/Install.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(Template.pm) perl(Test/BDD/Cucumber.pm) perl(Test/More.pm) perl(Weasel.pm) perl(Weasel/Driver/Mock.pm) perl(Weasel/Session.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Pherkin extension for web-testing
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EH/EHUELS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
# In the pherkin config file t/.pherkin.yaml:
   default:
     extensions:
       Pherkin::Extension::Weasel:
         default_session: selenium
         screenshots_dir: img
         screenshot_events:
            pre_step: 1
            post_scenario: 1
         sessions:
            selenium:
              base_url: http://localhost:5000
              driver:
                drv_name: Weasel::Driver::Selenium2
                wait_timeout: 3000
                window_size   1024x1280
                caps:
                   port: 4420

  # Which makes the S->{ext_wsl} field available,
  # pointing at the default session, in steps of features or scenarios
  # marked with the '@weasel' tag so in the steps you can use:

  use Weasel::FindExpanders::HTML;

  Then qr/I see an input element with label XYZ/, sub {
    S->{ext_wsl}->page->find('*labelled', text => 'XYZ');
  };
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES LICENSE README.md
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*

%changelog
