# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON/MaybeXS.pm) perl(Minilla.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Moo.pm) perl(OptArgs2.pm) perl(Test/Exception.pm) perl(Text/CSV.pm) perl(XML/Writer.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define module_name PickLE
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: An electronic component pick list application and file parser library.
Group: Development/Perl
License: artistic_2
URL: https://github.com/nathanpc/pickle

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NA/NATHANPC/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
If you're going to use this bundle only as a library to parse PickLE documents
it's super simple:

  use PickLE::Document;

  # Start from scratch.
  my $doc = PickLE::Document->new;
  $doc->add_category($category);
  $doc->save("example.pkl");

  # Load from file.
  $doc = PickLE::Document->load("example.pkl");

  # List all document properties.
  $doc->foreach_property(sub {
    my $property = shift;
    say $property->name . ': ' . $property->value;
  });

  # List all components in each category.
  $doc->foreach_category(sub {
    my $category = shift;
    $category->foreach_component(sub {
      my ($component) = @_;
      say $component->name;
    });
  });

For the command-line application you can just run `pickle' and you'll be
presented with the up-to-date usage of the tool.

This bundle also comes with a web server that can be used as a microservice to
parse PickLE documents. In order to use this you just run `picklews' which is a
the Mojolicious manpage web application and accepts the common command-line arguments
described in the Mojolicious::Commands manpage.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/P*
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
