Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Pipeline
Version:        3.12
Release:        alt2_29
Summary:        Generic pipeline interface
License:        GPL+ or Artistic
URL:            http://search.cpan.org/dist/Pipeline/
Source0:        http://www.cpan.org/authors/id/R/RC/RCLAMP/Pipeline-%{version}.tar.gz
# Fix compatibility with Pod-Parser-1.51, CPAN RT #77896
Patch0:         Pipeline-3.12-Fix-POD-to-obey-stricter-Pod-Parser-1.51.patch
BuildArch:      noarch
# Build
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Class/ISA.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Data/UUID.pm)
BuildRequires:  perl(Error.pm)
BuildRequires:  perl(File/Spec.pm)
# XXX: BuildRequires:  perl(IO::Handle)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(warnings/register.pm)
# Tests only
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(IO/Null.pm)
BuildRequires:  perl(IO/String.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Pod/Checker.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Simple.pm)
BuildRequires:  perl(vars.pm)
# Optional tests only
# XXX: BuildRequires:  perl(Acme::Colour)
BuildRequires:  perl(Data/Structure/Util.pm)
Requires:       perl(Class/ISA.pm) >= 0.010
Requires:       perl(Data/UUID.pm) >= 0.010
Requires:       perl(Error.pm) >= 0.150
Requires:       perl(File/Spec.pm)
Requires:       perl(Scalar/Util.pm) >= 0.010
Requires:       perl(Storable.pm)
Requires:       perl(threads.pm)





Source44: import.info
%filter_from_requires /^perl(Class.ISA\\)$/d
%filter_from_requires /^perl(Data.UUID\\)$/d
%filter_from_requires /^perl(Error\\)$/d
%filter_from_requires /^perl(Scalar.Util\\)$/d

%description
Pipelines are a mechanism to process data. They are designed to be plugged
together to make fairly complex operations act in a fairly straightforward
manner, cleanly, and simply.

%prep
%setup -q -n Pipeline-%{version}
%patch0 -p1

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc CHANGES README
%{perl_vendor_privlib}/*

%changelog
