# BEGIN SourceDeps(oneline):
BuildRequires: perl(Catmandu.pm) perl(Catmandu/Exporter/Template.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Parser/MGC.pm) perl(Plack.pm) perl(SRU.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Throwable/Error.pm) perl(Type/Tiny.pm) perl(URI.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name Plack-App-Catmandu-SRU
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: drop in replacement for Dancer::Plugin::Catmandu::SRU
Group: Development/Perl
License: perl
URL: https://github.com/LibreCat/Plack-App-Catmandu-SRU

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NJ/NJFRANCK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Plack::Builder;
    Plack::App::Catmandu::SRU;

    builder {
        enable 'ReverseProxy';
        enable '+Dancer::Middleware::Rebase', base  => Catmandu->config->{uri_base}, strip => 1;
        mount "/sru" => Plack::App::Catmandu::SRU->new(
            store => 'search',
            bag   => 'publication',
            cql_filter => 'type = dataset',
            limit  => 100,
            maximum_limit => 500,
            record_schemas => [
                {
                    identifier => "info:srw/schema/1/mods-v3.6",
                    title => "MODS",
                    name => "mods_36",
                    template => "views/export/mods_36.tt",
                    fix => 'fixes/pub.fix'
                },
            ],
        )->to_app;
    };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/P*

%changelog
