%define module_version 0.04
%define module_name Plack-App-REST
# BEGIN SourceDeps(oneline):
BuildRequires: perl(HTTP/Exception.pm) perl(HTTP/Request/Common.pm) perl(Module/Build/Tiny.pm) perl(Plack.pm) perl(Plack/App/URLMap.pm) perl(Plack/Builder.pm) perl(Plack/Component.pm) perl(Plack/Middleware.pm) perl(Plack/Test.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Perl PSGI App that just call http method from object.
Group: Development/Perl
License: perl
URL: https://github.com/vasekd/Plack-App-REST

Source0: http://cpan.org.ua/authors/id/V/VA/VASEKD/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Plack::App::REST is simple plack application that call requested method directly from mounted class.

Method can be GET, PUT, POST, DELETE, HEAD, PATCH. 

Each method is called with three params:

=over 4

=item * Env - Plack Env

=item * Params - resource identifier (usually id). /help/123 => return 123

=item * Data - Compatibility with Plack::Middleware::ParseContent. Return parsed data as perl structure

Method SHOULD return array with two params (body and header). Body is ref to perl structure, header is an array.
Header is optional.

=back

For complete RestAPI in Perl use: 

=over 4

=item * Plack::Middleware::ParseContent

=item * Plack::Middleware::FormatOutput

=back


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/P*

%changelog
