%define module_name Plack-App-dbi2http
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBI.pm) perl(DBIx/FunctionalAPI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(File/Write/Rotate.pm) perl(Getopt/Long.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Perinci/Access/Base/Patch/PeriAHS.pm) perl(Plack/Builder.pm) perl(Plack/Util/PeriAHS.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(YAML/Syck.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Export DBI database as HTTP API (Riap::HTTP)
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Plack-App-dbi2http

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a sample Plack application, which you can customize, to
export a DBI database as a HTTP API service.

I was reading Yanick's blog entry today,
http://techblog.babyl.ca/entry/waack, titled *Instant REST API for Any
Databases* and I thought I'd quickly cobble up something similar using a
different toolbox. Granted, the resulting HTTP API is not REST (read: it's
better :-) and at 0.01 the API functions are somewhat limited
(the DBIx::FunctionalAPI manpage) but this demonstrates how easy it is to create
something usable.

The tools and frameworks are: the DBIx::FunctionalAPI manpage which provides a set of
functions: `list_tables', `list_columns', `list_rows', `create_table',
`create_row', `rename_table', etc. These are normal Perl functions that accept
`dbh', `table' arguments and so on.

Next we have the Perinci::Access::HTTP::Server manpage, a set of the Plack manpage middlewares
that let you access Perl functions over HTTP using the the Riap::HTTP manpage protocol.
We compose the middlewares in a PSGI application called `dbi2http.psgi'.

All you need to do now is just run the PSGI application with the Plack manpage, using one
of the many available PSGI servers. There is a configuration file required, to
be put in the home directory, and can be copied from the provided sample config.
All you need to set is basically just path to log file and the DBI connection
information (db_dsn, db_user, db_password) and you're good to go.

After the PSGI application is running, you can connect using a plain HTTP client
like curl. Riap::HTTP exposes Perl modules and functions directly as URL
paths. For example, you can just request the root URL first, and a help message
is returned:

 %% curl http://localhost:5000/
 function        list_columns
 function        list_rows
 function        list_tables

 Tips:
 * To call a function, try:
     http://localhost:5000/api/list_tables
 * Function arguments can be given via GET/POST params or JSON hash in req body
 * To find out which arguments a function supp...

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
