%define module_name Plack-Middleware-BasicStyle
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTML/Parser.pm) perl(HTTP/Request/Common.pm) perl(Plack/Builder.pm) perl(Plack/Middleware.pm) perl(Plack/Request.pm) perl(Plack/Test.pm) perl(Plack/Util.pm) perl(Plack/Util/Accessor.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001001
Release: alt1
Summary: Add a basic <style> element to pages that don't have one
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Plack::Middleware::BasicStyle is a Plack middleware that adds a basic
<style> element to HTML pages that do not have a stylesheet.

The default style, taken from
http://bettermotherfuckingwebsite.com, is (before minification):

  <style>
    body {
      margin:40px auto;
      max-width: 650px;
      line-height: 1.6;
      font-size:18px;
      color:#444;
      padding:0 10px
    }

    h1,h2,h3 {
      line-height:1.2
    }
  </style>

The middleware takes the following arguments:

=over

=item style

This is the HTML fragment that will be added to unstyled pages.

It defaults to the value of
`$Plack::Middleware::BasicStyle::DEFAULT_STYLE'.

=item any_content_type

If true, don't check whether Content-Type contains `text/html'.

If false (default), passes the response through unchanged if the
Content-Type header is unset or does not contain the case-insensitive
substring `text/html'.

=item even_if_styled

If true, don't check whether the response already includes a <style>
or <link ... rel="stylesheet"> element.

If false (default), passes the response through unchanged if the
response includes a <style> or <link ... rel="stylesheet"> element.

=item use_link_header

If false or unset (default), the given HTML fragment will be added
right after the <head> start tag (if this exists), right after the
<html> start tag (if this exists but <head> doesn't), or at the
beginning of the document (if neither <html> nor <head> exists).

If set, its value is interpreted as an URL path. The body of the
response will not be modified, instead a `Link:' HTTP header will be
added to unstyled pages. Additionally, the middleware will intercept
requests to that exact URL path and return the style (with status 200,
a Content-Type of `text/css', a correct Content-Length header, and a
Cache-Control header instructing the browser to cache the style for 30
days).

Setting this makes the module more resilient to bugs and more
efficient at the cost of asking the client to make an extra request.
Therefore setting this argument ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
