%define module_name Plack-Middleware-CSP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/CSPHeader.pm) perl(HTTP/Request/Common.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Path/Tiny.pm) perl(Plack.pm) perl(Plack/Builder.pm) perl(Plack/Middleware.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Apply L<HTTP::CSPHeader>s to your psgi application.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AS/ASHLEY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use utf8;
 use strict;
 use warnings;
 use Plack::Builder;
 use Plack::Middleware::CSP;

 my $app = sub {
     my $env = shift;
     [ 200,
       [ "content-type" => "text/plain; charset=utf-8" ],
       [ "OHAI $env->{CSP_NONCE}" ] ]
 };

 # CSP middleware takes the arguments for HTTP::CSPHeader.
 builder {
     enable "CSP" =>
         policy => {
             'default-src' => q['self'],
             'script-src'  => q['self'],
         }, nonces_for => 'script-src';

     mount "/" => $app;
 };

Test it.e'

 plackup app.psgi

See the headers.e'

 curl -I http://0:5000/

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
