%define module_version 0.03
%define module_name Plack-Middleware-CookieMonster
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Module/Build.pm) perl(Plack.pm) perl(Plack/Builder.pm) perl(Plack/Middleware.pm) perl(Plack/Request.pm) perl(Plack/Test.pm) perl(Plack/Util/Accessor.pm) perl(Test/Most.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Eats all your (session) cookies in case Plack::Middleware::StrackTrace ate your HTTP headers.
Group: Development/Perl
License: perl
URL: https://github.com/mannih/Plack-Middleware-CookieMonster

Source0: http://cpan.org.ua/authors/id/M/MA/MANNI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
When developing a plack application with Plack::Middleware::StackTrace enabled,
you may sometimes find yourself in a situation where your current session for
your webapp is borked. Your app would usually clear any session cookies in that
case, but since Plack::Middleware::StackTrace will simply throw away any HTTP
headers you set, you'll be stuck to that session.

`Plack::Middleware::CookieMonster' will detect that `Plack::Middleware::StackTrace'
rendered a stack trace and will add `Set-Cookie' headers to the response so that
the cookies you configured or all cookies that the browser sent will be expired.

This middleware was written because I was too lazy to search the "clear cookies"
control in my browser and because I think we should automate as much as possible.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/P*

%changelog
