%define module_name Plack-Middleware-Debug-RefCounts
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Data/Dumper.pm) perl(Devel/Gladiator.pm) perl(Env.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Request/Common.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Plack/Builder.pm) perl(Plack/Middleware/Debug.pm) perl(Plack/Middleware/Debug/Base.pm) perl(Plack/Test.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Strict.pm) perl(Test/Version.pm) perl(Test2/Bundle/More.pm) perl(Test2/Require/AuthorTesting.pm) perl(namespace/clean.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.910.1
Release: alt1
Summary: reference count debugging for plack apps
Group: Development/Perl
License: artistic_2
URL: https://github.com/GrantStreetGroup/Plack-Middleware-Debug-RefCounts

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GS/GSG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module aims to provide debugging tools to help identify memory leaks.

It uses the Devel::Gladiator manpage to compare reference counts at the beginning and end
of requests.

To get the most out of this module, you should:

=over

=item 1. Run you application with a single worker process.

The middleware attempts not to unduly accumulate references. As such, it tracks
references counts in a simple package variable (the Arena_Refs entry elsewhere in this document), which does not
scale to multiple processes.

=item 2. Identify what's growing unexpectedly, *then* dive in.

See the explanation under the PLACK_MW_DEBUG_REFCOUNTS_DUMP_RE entry elsewhere in this document.

Generally, just be aware that you're potentially looking at A LOT of
information, and trying to debug it takes up a lot of resources. System
errors may occur if you're too aggressive.

=item 3. Repeat tests to make sure they are consistently leaking memory.

Objects can be loaded the first time you load a specific web page, and increase
memory usage.  The key is that they don't continue to increase memory after
repeated hits.

Preloading data prior to forking can help with this problem, but it can be hard
to capture every single object or singleton that needs to be loaded.

=back

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES README LICENSE CONTRIBUTING.md
%perl_vendor_privlib/P*

%changelog
