%define module_name Plack-Middleware-LogStderr
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(Module/Build.pm) perl(Plack/Middleware.pm) perl(Plack/Test.pm) perl(Plack/Util/Accessor.pm) perl(Scalar/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(if.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: Everything printed to STDERR sent to psgix.logger or other logger
Group: Development/Perl
License: perl
URL: https://github.com/amalek215/Plack-Middleware-LogStderr

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AM/AMALEK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This middleware intercepts all output to `STDERR' and redirects it to a defined
logger.

Examples where `STDERR' output would not typically be sent to a logger:

  print STDERR "foo";
  system('perl -e " print STDERR \'bar\'"');
  warnings::warn("baz");

This middleware uses two techniques to catch messages sent to `STDERR' and
direct them to a logger.

The first ties the `STDERR' filehandle and directs all print messages to a logger.
This method only works if the code printing to `STDERR' is aware of the Perl
tied filehandle.

The second technique uses the Capture::Tiny manpage to capture everything else written to
`STDERR' (for example any programs run using `system'). This method groups all
`STDERR' output into one message. The drawback here is log messages may not be
interleaved temporally with messages generated from the tied method or other
calls to the logger.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES LICENSE
%perl_vendor_privlib/P*

%changelog
