# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Plack/Middleware.pm) perl(Plack/Util/Accessor.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 0.0001
%define module_name Plack-Middleware-Prometheus-RequestTimes
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0001
Release: alt1
Summary: record response times with a prometheus histogram.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NEWELLC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
To setup a prometheus metrics app in your PSGI application register
hook this middleware up with a histogram and the metrics can report
on your response times.

_use strict;
_use warnings;
_use My::Website;
_use Net::Prometheus;
_use Net::Prometheus::ProcessCollector;

_my $client = Net::Prometheus->new;

_$client->register( Net::Prometheus::ProcessCollector->new(
_   prefix => "parent_process",
_   pid => getppid(),
_) );
_my $response_times = $client->new_histogram(
__name => "response_times",
__help => "Application response times",
_);

_use Plack::Builder;

_my $app = My::Website->apply_default_middlewares(My::Website->psgi_app);

_builder {
__mount "/metrics" => $client->psgi_app;
__mount '/' => builder {
___enable 'Prometheus::RequestTimes', observer => $response_times;
___$app;
__};
_};
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/P*

%changelog
