# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/StackTrace/AsHTML.pm) perl(HTTP/Request/Common.pm) perl(MIME/Base64.pm) perl(Module/Build/Tiny.pm) perl(Plack/Middleware.pm) perl(Plack/Middleware/StackTrace.pm) perl(Plack/Test.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Requires.pm) perl(Try/Tiny.pm) perl(overload.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Plack-Middleware-StackTrace-RethrowFriendly
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Display the original stack trace for rethrown errors
Group: Development/Perl
License: perl
URL: https://github.com/tarao/perl5-Plack-Middleware-StackTrace-RethrowFriendly

Source0: http://cpan.org.ua/authors/id/T/TA/TARAO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This middleware is the same as the Plack::Middleware::StackTrace manpage except
that additional information for rethrown errors are available for HTML
stack trace.

If you catch (`eval' or `try'-`catch' for example) an error and
rethrow (`die' or `croak' for example) it, all the errors including
rethrown ones are visible through the throwing point selector at the
top of the HTML.

For example, consider the following code.

  sub fail {
      die 'foo';
  }

  sub another {
      fail();
  }

  builder {
      enable 'StackTrace';

      sub {
          eval { fail() }; # (1)
          another();       # (2)

          return [ 200, [ 'Content-Type' => 'text/plain' ], [ 'OK' ] ];
      };
  };

the Plack::Middleware::StackTrace manpage blames (1) since it is the first
place where `'foo'' is raised.  This behavior may be misleading if
the real culprit was something done in `another'.

`Plack::Middleware::StackTrace::RethrowFriendly' displays stack
traces of both (1) and (2) in each page and (1) is selected by
default.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/P*

%changelog
