# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Pod-Loom
%define upstream_version 0.08

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Do-nothing template for Pod::Loom
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Pod/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Role.pm)
BuildRequires: perl(PPI.pm)
BuildRequires: perl(Pod/Eventual.pm)
BuildRequires: perl(String/RewritePrefix.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
Pod::Loom extracts all the POD sections from Perl code, passes the POD to a
template that may reformat it in various ways, and then returns a copy of
the code with the reformatted POD at the end.

A template may convert non-standard POD commands like '=method' and '=attr'
into standard POD, reorder sections, and generally do whatever it likes to
the POD.

The document being reformatted can specify the template to use with a line
like this:

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%{make}

%check
%{make} test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
