%define module_name Pod-Thread
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(IPC/System/Simple.pm) perl(Module/Build.pm) perl(Perl6/Slurp.pm) perl(Pod/Simple.pm) perl(Text/Balanced.pm) perl(autodie.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.01
Release: alt1
Summary: Convert POD data to the HTML macro language thread
Group: Development/Perl
License: mit
URL: https://www.eyrie.org/~eagle/software/pod-thread/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RR/RRA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Pod::Thread is a module that can convert documentation in the POD format
(the preferred language for documenting Perl) into thread, an HTML macro
language.  It lets the converter from thread to HTML handle some of the
annoying parts of conversion to HTML.

As a derived class from Pod::Simple, Pod::Thread supports the same methods and
interfaces.  See the Pod::Simple manpage for all the details; briefly, one creates a
new parser with `Pod::Thread->new()', sets the output destination with
either output_fh() or output_string(), and then calls one of parse_file(),
parse_string_document(), or parse_lines().

new() can take the following options, in the form of key/value pairs, to
control the behavior of the formatter:

=over 4

=item contents

If set to a true value, output a table of contents section at the beginning of
the document.  Only top-level headings will be shown.

=item id

Sets the CVS Id string for the file.  If this isn't set, Pod::Thread will
try to find it in the file.

=item navbar

If set to a true value, output a navigation bar at the beginning of the
document with links to all top-level headings.

=item style

Sets the name of the style sheet to use.  If not given, no reference to a
style sheet will be included in the generated page.

=item title

The title of the document.  If this is set, it will be used rather than
looking for and parsing a NAME section in the POD file, and NAME sections
will no longer be required or special.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes README.md docs
%perl_vendor_privlib/P*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
