%define module_name Pod-Weaver-Plugin-Bencher-Scenario
%filter_from_requires /perl(Acme.CPANModulesUtil.Bencher.pm)/d
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/CPANModulesUtil/Bencher.pm) perl(Bencher/Backend.pm) perl(Data/Dmp.pm) perl(Dist/Zilla/File/InMemory.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/MaybeXS.pm) perl(Markdown/To/POD.pm) perl(Moose.pm) perl(Perinci/Result/Format/Lite.pm) perl(Perinci/Sub/ConvertArgs/Argv.pm) perl(Perinci/Sub/Normalize.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Weaver.pm) perl(Pod/Weaver/Role/AddTextToSection.pm) perl(String/PodQuote.pm) perl(String/ShellQuote.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.253
Release: alt1
Summary: Plugin to use when building Bencher::Scenario::* distribution
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Pod-Weaver-Plugin-Bencher-Scenario

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin is to be used when building `Bencher::Scenario::*' distribution.
Currently it does the following:

For each `lib/Bencher/Scenario/*' module files:

=over

=item * Add a Synopsis section (if doesn't already exist) containing a few examples on how to use the scenario

=item * Add a description about Bencher in the Description section

=item * Add a Benchmark Participants section containing list of participants from the scenario

=item * Add a Sample Benchmark Results containing result from a bencher run

Both normal benchmark and a separate module startup benchmark (if eligible) are
run and shown.

=item * Add a Benchmarked Modules section containing list of benchmarked modules (if any) from the scenario and their versions

=item * Create lib/Bencher/ScenarioR/* module files that contain sample benchmark result data

These module files contain the raw data, while the Sample Benchmark Results POD
section of the scenario module contains the formatted result. The raw data might
be useful later. For example I'm thinking of adding a utility later, perhaps in
the form of an the lcpan manpage subcommand, that can guess whether a module is
relatively fast or slow (compared to similar implementations, which are other
participants on benchmark scenarios). The utility can then suggest faster
alternatives.

=back

For each `lib/Bencher/Scenario/*' module files:

=over

=item * Add list of scenario modules at the beginning of Description section

=back

=for Pod::Coverage .*

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/P*

%changelog
