# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find/Rule.pm) perl(File/Spec.pm) perl(File/Spec/Unix.pm) perl(Log/Dispatchouli.pm) perl(Moose.pm) perl(PPI.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Elemental.pm) perl(Pod/Elemental/PerlMunger.pm) perl(Pod/Elemental/Transformer.pm) perl(Pod/Elemental/Transformer/Pod5.pm) perl(Pod/Find.pm) perl(Pod/Weaver.pm) perl(Pod/Weaver/Role/Dialect.pm) perl(Pod/Weaver/Role/Preparer.pm) perl(Software/License/BSD.pm) perl(Test/Differences.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Pod-Weaver-Plugin-Include
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.9
Release: alt1
Summary: Support for including segments of Pod from other files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VR/VRURG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is a the Pod::Weaver manpage plugin for making it possible to include segments of
Pod documentation being included from one file into another. This is useful when
one has a piece of documentation which is nice to have included into a couple of
documentations. So, instead of telling a user to 'go see this info in *that*
file' one could simply have this info included from *that* file into *this*
file.

For example, let's say we have a script `useful_tool' which is handling its
command line processing to a module `Core'. In turn, the module gathers
information about standard command line options from modules `Core::Mod1',
`Core::Mod2', etc. So far, so good until one writes another script
`noless_useful', which is based upon the module `Core' too. Yet, even worse .e'
it adds its own command lines the list gathered by `Core'! With standard Pod
documentation for the common set of options would have to be copy-pasted into
each script documentation. For the latter one it's own options must be included.
And then if any documentation would be changed in the original modules we would
have not forget update both scripts' docs too!

Phew...

`Pod::Weaver::Plugin::Include' solves the issue by defining a concept of
template (borrowed from archaic the Pod::Template manpage) and allowing a template to be
included by a third-party pod:

    # File lib/Core/Mod1.pm
    package Core::Mod1;
     
    ...
    
    # Template options won't be included into resulting Pod.
    =pod
    
    Here we define command line options for later use by calling module.
     
    =tmpl -options
    
    =item --option1
    
    document it
    
    =item --option2
    
    repeat
    
    =tmpl

%prep
%setup -q -n %{module_name}-v%{version}
rm -f t/010-weaving.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changelog README
%perl_vendor_privlib/P*

%changelog
