# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(AddressBook.pm)
# END SourceDeps(oneline)
%define module_version 2.32
%define module_name PostScript-MailLabels
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.32
Release: alt1
Summary: Modules for creating PostScript(tm) files of mailing address labels.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AJ/AJACKSON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The module has three distinct output modes. In my experience, printing
mailing labels is a matter of tweaking parameters to get them all to
fit properly on the page. This module is designed with this in mind.

The first output is the calibration sheet. This is a pair of annotated
axes, either in inches or centimeters, centered on the page and covering the
whole page in X and Y directions. The intent is for you to output this
page first, and simply read off the relevant page dimensions directly.

The second output is the label test. This output is a series of boxes drawn on
the page, meant to outline the edges of all the mailing labels.  Take this
sheet and line it up with a sheet of labels to see if they actually match
perfectly. If not, tweak the parameters until they do. Note that sometimes you
will get a message at the bottom of the sheet saying "Bottom gap too large,
last row cannot be printed". This means that the printable area of your printer
is too small to utilize the last row of labels. I have this problem. But I
handle it for you. Note also the arrows on the test sheet. As you hold the test
sheet over a sheet of labels, hold it up to the light and slide the test sheet
so that the boxes match the edges of the labels. If you slide in the arrow
direction, that is a positive adjustment. The other direction is negative. If
the edges of some boxes come out dashed, that means that the non-printing
border cuts off the end of the label, so I will adjust the printing area
appropriately. Don't try to line up the dashed lines with label edges - it
won't work. Just line up the solid lines.

The third output is the labels themselves. By default, I have set up a
US-centric address definition :

    firstname, lastname, street address, city, state, zipcode

But with version 2.0, you can now create your own definition. You can define
new fields, and you can define how those fields land on a label. You can also
control the fonts on a per-field basis. Not the size, yet - later pilgrim.

Parameters you can set :

Paper size, orientation, borders on the printable area (many printers will not
print right up to the edge of the paper), where the labels live on the page and
how big they are, overall x-y shift of page, whether or not to print PostNET
barcode, font, fontsize, units (english or metric), which Avery(tm) product
code to use, and where the first label starts.

This last needs explanation. If you have a partially used sheet of labels,
you might want to use it up. So you count the missing labels, starting
at the upper left, and counting across, and then down. For example, if
I have 3 columns of labels, label five is the second label in the second
row.

If you have an Avery(tm) or Dymo product that I haven't defined, send
me the specs and I'll add it.

Also, if there is another brand of labels that you use, send me the relevant
data and I'll add that as well. I suspect that there must be some other vendor
in Europe, but I don't know who that would be.

When setting up the addresses, I check to see if they will fit on the label.
If not, I try to shorten them semi-intelligently until they fit. This part
could use quite a bit more work, if done right it probably merits a module all
it's own.

Briefly, for the name line, I start trimming the ends off the first name, and
leave the last name alone.

For the street, I look for things like Road or Avenue and nuke those first,
then I trim the street name from the right.

For the last line, I trim the city and leave the state and zip alone.

The barcode will be either a 5-digit zip or 9 digit zip-plus code. I could
also create the delivery point code, but since my mailing labels are not
even wide enough for the 9 digit zip-plus, I haven't bothered. I have read
the USPS spec on the barcode, and so far as I can tell, I meet the spec.
Barcode is complicated. There are 3 flavors. 5-digit zip, 9-digit zip,
and Delivery Point barcode which includes the street address. So the
postal bar code can be 32, 52, or 62 bars long. If you start comparing
what I produce with what you see on your mail, they may look different.
http://pe.usps.gov/cpim/ftp/pubs/Pub25/Pub25.pdf can answer all questions.

labelsetup :
    
All the distances are in units of inches or centimeters, depending on the Units flag.
A hash of the label definition will be returned.
_
    my $setup = $labels -> labelsetup( 

        #    paper size

        PaperSize        => 'Letter',
        options are : 
                    Letter Legal Ledger Tabloid A0 A1 A2 A3 A4 A5 A6 A7 A8
                    A9 B0 B1 B2 B3 B4 B5 B6 B7 B8 B9 Envelope10 Envelope9
__    Envelope6_3_4 EnvelopeC5 EnvelopeDL Folio Executive Userdefined

        If 'Userdefined' is used, then variables Width and Height need to be set.

__orientation      => 'portrait',
___the other possibility is 'landscape'

__encoding    => 'StandardEncoding', # or ISOLatin1Encoding
__
        #   printable area on physical page - these numbers represent border widths
        #    typical values might be 0.25 inches

        Printable_Left   => 0.0,
        Printable_Right  => 0.0,
        Printable_Top    => 0.0,
        Printable_Bot    => 0.0,

        #    define where the labels live (ideally)

        Output_Top     => 1.0, where does the top of the first label sit?
        Output_Left    => 0.5, where is the left edge of the first label?
        Output_Width   => 3.0, how wide are the labels?
        Output_Height  => 2.0, how tall are the labels?
        X_Gap          => 0.1, what is the vertical gap between labels?
        Y_Gap          => 0.0, what is the horizontal gap between labels?
        Number         => 30,  how many labels per page?
        Columns        => 3,   how many columns per page? (optional)

        if the number of columns are given, I'll check your math to see if the page
        width approximately equals the sum of the label widths plus gaps etc.

        #    Adjustments for printer idiosyncracies

        X_Adjust       => 0.0, shift the whole thing over by this amount.
        Y_Adjust       => 0.0  shift the whole thing down by this amount.

        #    Other controls

        Postnet    => 'yes',  barcodes? yes or no
        Font       => 'Helvetica', which default font? see below for generating a list
        FontSize   => 12, how big are they?
        Units      => 'english', english or metric
        FirstLabel => 1, where is the first label (begins at 1).

        # set equal to the Avery(tm) product code, and the label description
        # will be updated from the database.
        Avery        => undef,

        # set equal to the Dymo(tm) product code, and the label description
        # will be updated from the database.
        Dymo        => undef,

        );

        generate a PostScript(tm) file with rulers on it for making measurements
    $output = $labels->labelcalibration ;
        generate a PostScript(tm) file with boxes showing where the text will land
    $output = $labels->labeltest ;
        the main event - make me a label file
    $output = $labels->makelabels(\@addrs) ;

        translate an Avery(tm) product code into a template code.
    $templatecode = $labels->averycode($product_code) ;
        translate an Dymo(tm) product code into a template code.
    $templatecode = $labels->dymocode($product_code) ;
        retrieve an array of the paper width, height (in points)
    @width_height = @{ $labels->papersize } ;
        get the length of a string in points using the current font
    $stringwidth = $labels->stringwidth("This is a string") ;
        get a list of the available fonts
    @fontname = $labels->ListFonts;

    Components:

    Each component has a name, and four attributes. The attributes are :
        type : must be name, road, place, or bar. This defines the trimming
               strategy. 
        adj : yes or no. Is trimming allowed?
        font : what font to use
        index : which entry in the input array will contain this component?

    Default components :
        #    first name
        fname    => { type => 'name', adj => 'yes', font => 'Helvetica', 'index' => 0 },
        #    last name
        lname    => { type => 'name', adj => 'yes', font => 'Helvetica', 'index' => 1 },
        #    street address and street
        street    => { type => 'road', adj => 'yes', font => 'Helvetica', 'index' => 2 },
        #    city
        city    => { type => 'place', adj => 'yes', font => 'Helvetica', 'index' => 3 },
        #    state
        state    => { type => 'place', adj => 'no', font => 'Helvetica', 'index' => 4 },
        #    country
        country    => { type => 'place', adj => 'no', font => 'Helvetica', 'index' => 6 },
        #    zip
        zip    => { type => 'place', adj => 'no', font => 'Helvetica', 'index' => 5 },
        #    postnet (bar code)
        postnet    => { type => 'bar', adj => 'no', font => 'PostNetJHC', 'index' => 5 },

    Editing components : with editcomponent

    #    What address components are available?
    print "components : ",join(' : ',@{$labels->editcomponent()}),"\n";

    #    Lets make the lname (lastname) bold-faced
    $labels->editcomponent('lname', 'name', 'no', 1, 'Times-Bold' );

    #    Lets create a new component
    $labels->editcomponent('company_name', 'name', 'yes', 7, 'Times-Bold');

    Label definition

    We define the label layout line by line, by describing for each line which
    components we want printed, and in what order.

    #    Default label definition
        #    line 1
        [ 'fname', 'lname' ],
        #    line 2
        [ 'street', ],
        #    line 3
        [ 'city', 'state', 'zip' ],
        #    line 4
        [ 'postnet', ],

    edit the label definition with definelabel :

    definelabel(line number, component, component, ...)

    #    first clear the old (default) definition
    $labels->definelabel('clear');
    #                   line number, component list
    $labels->definelabel(0,'pgm_name','version');
    $labels->definelabel(1,'blank',);
    $labels->definelabel(2,'author',);
    $labels->definelabel(3,'blank',);
    $labels->definelabel(4,'comments-1',);
    $labels->definelabel(5,'comments-2',);
    $labels->definelabel(6,'comments-3',);

_Free Text (Page Numbering)

_You can place an (almost) constant bit of text on every page.
_This is really to allow page numbering, slightly generalized.

_$labels->freetext (
__X => 500,
__Y => 15,
__Text => "Page %%page%%"
_);

_X and Y are the page coordinates, in *points* (72 points per inch), and
_remember that Y starts at the bottom and goes up, so (500, 15) puts the
_text at the bottom right corner of an 8.5x11 sheet.

_The special token %%page%% will be replaced with the current page number.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%files scripts
%_bindir/*

%changelog
