%define module_version 1.01
%define module_name Prancer-Plugin-Log4perl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Log/Log4perl.pm) perl(Plack/Runner.pm) perl(Prancer.pm) perl(Prancer/Core.pm) perl(Prancer/Plugin.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Try/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: >load();
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLOCKABY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This plugin connects your the Prancer manpage application to the Log::Log4perl manpage and
exports a keyword to access the configured logger. You don't *need* this
module to log things but it certainly makes it easier.

There is very minimal configuration required to get started with this module.
To enable the logger you only need to do this:

    use Prancer::Plugin::Log4perl qw(logger);

    Prancer::Plugin::Log4perl->load();

    logger->info("hello, logger here");
    logger->fatal("something done broke");

By default, this plugin will initialize the Log::Log4perl manpage with a very basic
configuration to avoid warnings when used. You can override the configuration
by loading your own before calling `load' on this plugin. This plugin's
`load' implementation simply calls `Log::Log4perl->initialized()' to see
if it should load its own. For example, you might do this:

    use Prancer::Plugin::Log4perl qw(logger);

    Log::Log4perl::init('/etc/log4perl.conf');
    Prancer::Plugin::Log4perl->load();

The `logger' keyword gets you direct access to an instance of the logger and
you can always call static methods on the Log::Log4perl manpage and interact with the
logger that way, too.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/P*

%changelog
