%define module_version 1.06
%define module_name Prancer-Plugin-Xslate
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Plack/Runner.pm) perl(Prancer.pm) perl(Prancer/Core.pm) perl(Prancer/Plugin.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Text/Xslate.pm) perl(Try/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: >load();
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLOCKABY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This plugin provides access to the the Text::Xslate manpage templating engine for your
the Prancer manpage application and exports a keyword to access the configured engine.

This template plugin supports setting the basic configuration in your Prancer
application's configuration file. You can also configure all options at runtime
using arguments to `render'.

To set a configuration in your application's configuration file, begin the
configuration block with `template' and put all options underneath that. For
example:

    template:
        cache_dir: /path/to/cache
        verbose: 2

Any option for Text::Xslate whose value can be expressed in a configuration
file can be put into your application's configuration. Then using the template
engine is as simple as this:

    use Prancer::Plugin::Xslate qw(render);

    my $plugin = Prancer::Plugin::Xslate->load();
    $plugin->add_module("Data::Dumper");

    print render("foobar.tx", \%%vars);

However, there are some configuration options that cannot be expressed in
configuration files, especially the `functions' option. So there is a second
way to handle that.

    print render("foobar.tx", \%%vars, {
        'function' => {
            'md5_hex' => sub {
                return Digest::MD5::md5_hex(@_);
            }
        }
    });

The optional third argument to `render' can be a hashref with additional,
overriding options for the Text::Xslate manpage.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE examples
%perl_vendor_privlib/P*

%changelog
