%define module_version 1.01
%define module_name Prancer-Session-Store-Database
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/Mock.pm) perl(DBD/Pg.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Plack/Session/Store.pm) perl(Storable.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Try/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: perl module %module_name
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLOCKABY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements a session handler that stores sessions in a database. It
creates its own database connection, separate from any existing database
connection, to avoid any issues with transactions. It wraps all changes to the
database in transactions to ensure consistency.

This configuration expects a database table that looks like this:

    CREATE TABLE session (
        id CHAR(72) NOT NULL,
        application VARCHAR DEFALUT '' NOT NULL,
        timeout integer DEFAULT date_part('epoch'::text, now()) NOT NULL,
        data TEXT
    );

    CREATE UNIQUE INDEX session_uq ON sessions (id, application);
    CREATE INDEX session_timeout_ix ON sessions (timeout);

Additional columns may be added as desired but they will not be used by this
session handler.

To use this session handler, add this to your configuration file:

    session:
        store:
            driver: Prancer::Session::Store::Database::Driver::DriverName
            options:
                table: sessions
                database: test
                username: test
                password: test
                hostname: localhost
                port: 5432
                charset: utf8
                connection_check_threshold: 10
                expiration_timeout: 3600
                autopurge: 0
                autopurge_probability: 0.1
                application: foobar
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/P*

%changelog
