# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN/Meta.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Readme/Brief.pm) perl(Software/LicenseUtils.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Proc-Fork
%define upstream_version 0.808

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Simple, intuitive interface to fork()
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Proc/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Exporter/Tidy.pm)
BuildArch:  noarch
Source44: import.info

%description
This module provides an intuitive, Perl-ish way to write forking programs
by letting you use blocks to illustrate which code section executes in
which fork. The code for the parent, child, retry handler and error handler
are grouped together in a "fork block". The clauses may appear in any
order, but they must be consecutive (without any other statements in
between).

All four clauses need not be specified. If the retry clause is omitted,
only one fork will be attempted. If the error clause is omitted the program
will die with a simple message if it can't retry. If the parent or child
clause is omitted, the respective (parent or child) process will start
execution after the final clause. So if one or the other only has to do
some simple action, you need only specify that one. For example:

 # spawn off a child process to do some simple processing
 run_fork { child {
     exec '/bin/ls', '-l';
     die "Couldn't exec ls: $!\n";
 } };
 # Parent will continue execution from here
 # ...

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README eg
%perl_vendor_privlib/*

%changelog
