%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Callback.pm) perl(Eval/LineNumbers.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Slurp/Remote.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Hash/Util.pm) perl(IO/Event.pm) perl(List/MoreUtils.pm) perl(Module/Load.pm) perl(Object/Dependency.pm) perl(POSIX.pm) perl(Proc/Background.pm) perl(RPC/ToWorker.pm) perl(Scalar/Util.pm) perl(Sys/Hostname.pm) perl(Test/More.pm) perl(Tie/Function/Examples.pm) perl(Time/HiRes.pm) perl(aliased.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.903
%define module_name Proc-JobQueue
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.903
Release: alt1
Summary: Jobqueue with dependency graph
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MU/MUIR/modules/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Generic queue of "jobs".   Most likely to be subclassed
for different situations.  Jobs are registered.  Hosts are
registered.  Jobs may or may not be tied to particular hosts.
Jobs are started on hosts.  Jobs may or may not have 
dependencies on each other.

Proc::JobQueue does not start jobs on its own: it needs something
to call `startmore()' every now and then.   Two subsclasses
provide this complete Proc::JobQueue: 
the Proc::JobQueue::EventQueue manpage which provides an event-based
framework using the IO::Event manpage and the Proc::JobQueue::BackgroundQueue manpage
which provides a simple loop-until-all-the-jobs-are-done construct.

From the jobs point of view, it will be started with:

  $job->jobnum($jobnum);
  $jobnum = $job->jobnum();
  $job->queue($queue);
  $job->host($host);
  $job->start();

When jobs complete, they must call:

  $queue->jobdone($job, $do_startmore, @exit_code);

Jobs are run on hosts which must be added with:

  $queue->addhost($hostname, jobs_per_host => $number_to_run_on_this_host_at_one_time)

Jobs can be 
shell commands (the Proc::JobQueue::Command manpage), 
a sequence of other jobs (the Proc::JobQueue::Sequence manpage),
some standard file operations (the Proc::JobQueue::Move manpage, the Proc::JobQueue::Sort manpage),
custom cubclasses of the base job class (the Proc::JobQueue::Job manpage),
arbitrary perl code (the Proc::JobQueue::DependencyJob manpage, the Proc::JobQueue::Task manpage),
or arbitary perl code pushed to a remote system to run (the Proc::JobQueue::RemoteDependencyJob manpage).


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGELOG
%perl_vendor_privlib/P*

%changelog
