# BEGIN SourceDeps(oneline):
BuildRequires: perl(User/pwent.pm)
# END SourceDeps(oneline)
%define module_name Proc-ProcessTable-Match
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.1
Release: alt1
Summary: Matches a Proc::ProcessTable::Process against a stack of checks.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Proc::ProcessTable::Match;
    use Proc::ProcessTable;
    use Data::Dumper;
    
    # looks for a kernel proc with the PID of 0
    my %%args=(
              checks=>[
                       {
                        type=>'PID',
                        invert=>0,
                        args=>{
                               pids=>['0'],
                               }
                       },{
                        type=>'KernProc',
                        invert=>0,
                        args=>{
                               }
                      }
                      ]
                     );
    
    # hits on every proc but the idle proc
    %%args=(
              checks=>[
                       {
                        type=>'Idle',
                        invert=>1,
                        args=>{
                               }
                       }
                      ]
                     );
    
    my $ppm;
    eval{
        $ppm=Proc::ProcessTable::Match->new( \%%args );
    } or die "New failed with...".$@;
    
    my $pt = Proc::ProcessTable->new;
    foreach my $proc ( @{$t->table} ){
        if ( $ppm->match( $proc ) ){
            print Dumper( $proc );
        }
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes ignore.txt README
%perl_vendor_privlib/P*

%changelog
