# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Errno.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(POSIX.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.23
%define module_name Proc-Queue
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.23
Release: alt1
Summary: limit the number of child processes running
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SALVA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module lets you parallelise a perl program using the `fork',
`exit', `wait' and `waitpid' calls as usual but without taking care
of creating too many processes and overloading the machine.

It redefines perl `fork', `exit', `wait' and `waitpid' core
functions. Old programs do not need to be reprogrammed, only the `use
Proc::Queue ...' sentence has to be added to them.

Additionally, the module has two debugging modes (debug and trace)
that seem too be very useful when developing parallel aplications:

=over 4

=item debug mode:

when active, dumps lots of information about processes being created,
exiting, being caught by parent, etc.

=item trace mode:

prints a line every time one of the `fork', `exit', `wait' or
`waitpid' functions are called.

=back

It is also possible to set a minimun delay time between fork calls
to stop too many processes for starting in a short time interval.

Child processes continue to use the modified functions, but their
queues are reset and the maximun process number for them is set to 1
(anyway, children can change their queue size themselves).

Proc::Queue doesn't work if CHLD signal handler is set to
`IGNORE'.  

Internally, Proc::Queue, automatically catches zombies and stores
their exit status in a private hash. To avoid leaking memory in long
running programs you have to call `wait' or `waitpid' to delete
entries from that hash or alternatively active the `ignore_children'
mode:

  Proc::Queue::ignore_children(1)

or

  use Proc::Queue ignore_children=>1, ...



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
