# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Proc-Short
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: - return short system calls with options
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JH/JHKIM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Proc::Short is intended to be an extension of the backticks .operator in PERL which incorporates a number of options, including 
collecting STDOUT and STDERR separately -- plus timeout and 
automatic retries.  A new process object is created by

   $myproc = Proc::Short->new();

The default will timeout after 30 seconds (*timeout*) for each 
attempt, will try a process up to 10 times, with 5 seconds 
between each try.  Either shell-like command lines or references 
to perl subroutines can be specified for launching a process in 
background.  A simple list process, for example, can be started 
via the shell as

   ($out, $in) = $myproc->run("ls");

or, as a perl subroutine, with

   $myproc->run(sub { return <*>; });

The *run* Method will try to run the named process.  If the 
process times out (after *time_per_try* seconds) or has a 
error defined as unacceptable, it will wait (for *time_btw_tries* 
seconds) and try again.  This can repeat until *maxtime* 
seconds or *num_tries* tries of the process to be run.  

The user can specify what constitutes an unacceptable error 
of STDOUT or STDERR output -- i.e. demanding a retry.  One 
common shorthand is to have the *run* method retry if there 
is any return from STDERR.  

   $myproc->accept_no_error();    # Re-try if any STDERR
   $myproc->pattern_stdout($pat); # require STDOUT to match regex $pat
   $myproc->pattern_stderr($pat); # require STDERR to match regex $pat


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*
%changelog
