# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Remove.pm) perl(File/Spec/Functions.pm) perl(FileHandle.pm) perl(IO/Handle.pm) perl(IO/String.pm) perl(IPC/Run3.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Params/Util.pm) perl(Probe/Perl.pm) perl(Scalar/Util.pm) perl(Storable.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.30
%define module_name Process
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.30
Release: alt1
Summary: Objects that represent generic computational processes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADAMK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
There are a great number of situations in which you may want to
model a computational process as an object.

An implementation of this sort of object generally looks like the following
when somebody uses it.

  my $object = MyProcessThingy->new( ... );
  
  my $rv = $object->run;
  
  if ( $rv ) {
      print "Thingy ran ok";
  } else {
      print "Failed to run thingy";
  }

The `Process' family of modules are intended to be used as base and
role classes for these types of objects. They are used to help identify
process objects, and enforce a common API on these objects.

The primary intent is to provide a common base for objects that will be
able to be used with various distributed processing systems, without
itself actually implementing any form of distributed system.

The scope of uses for Process includes solutions to address the following
scenarios.

=over 4

=item A single CPU on a single host

=item Multiple CPUs on a single host

=item Multiple hosts on a single network

=item Hosts distributed across the internet

=item Any processing resource accessible via any mechanism

=back

To put it another way, this family of classes is intended to addresses
the separation of concerns between the processing of something, and the
results of something.

The actual ways in which the processes are run, and the handling of the
results of the process are outside the scope of these classes.

The `Process' class itself is the root of all of these classes. In fact,
it is so abstract that it contains no functionality at all, and serves
primarily to indicate that an object obeys the general rules of a
`Process' class.

Most of the basic `Process' modules are similar. They define how your
object should behave (an API for a particular concept) without
dictating a particular implementation.

However, by using them, you are confirming to some processing system
that your objects will obey particular rules, and thus can interact
sanely with any processing system that follows the API.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/P*

%changelog
