%define module_name Proch-N50
Epoch: 2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FASTX/Reader.pm) perl(Getopt/Long.pm) perl(IPC/Cmd.pm) perl(JSON/PP.pm) perl(PerlIO/encoding.pm) perl(Pod/Usage.pm) perl(Term/ANSIColor.pm) perl(Text/ASCIITable.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.0
Release: alt1
Summary: Calculate N50 from a FASTA or FASTQ file without dependencies
Group: Development/Perl
License: mit
URL: https://metacpan.org/release/Proch-N50

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PR/PROCH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Proch::N50 qw(getStats getN50);
  my $filepath = '/path/to/assembly.fasta';

  # Get N50 only: getN50(file) will return an integer
  print "N50 only:\t", getN50($filepath), "\n";

  # Full stats
  my $seq_stats = getStats($filepath);
  print Data::Dumper->Dump( [ $seq_stats ], [ qw(*FASTA_stats) ] );
  # Will print:
  # %%FASTA_stats = (
  #               'N50' => 65,
  #               'dirname' => 'data',
  #               'size' => 130,
  #               'seqs' => 6,
  #               'filename' => 'small_test.fa',
  #               'status' => 1
  #             );

  # Get also a JSON object
  my $seq_stats_with_JSON = getStats($filepath, 'JSON');
  print $seq_stats_with_JSON->{json}, "\n";

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README CONTRIBUTING.md README.md docs
%perl_vendor_privlib/P*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
