# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(B.pm) perl(Carp.pm) perl(Config.pm) perl(English.pm) perl(Exporter.pm) perl(File/MimeInfo.pm) perl(File/Temp.pm) perl(File/stat.pm) perl(Mail/Sendmail.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Time/localtime.pm) perl(YAML.pm) perl(YAML/Tiny.pm) perl(YAML/XS.pm) perl-podlators
# END SourceDeps(oneline)
Summary(fr): Module Perl pour le support de divers OS (Linux/Solaris/...)
%add_findreq_skiplist %perl_vendor_privlib/ProjectBuilder/Env.pm /usr/bin/pbdistrogetparam
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    ProjectBuilder
%define upstream_version 0.16.1

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2
Summary:    Perl module providing multi-OSes continuous packaging
License:    GPL
Group:      System/Configuration/Packaging
Url:        http://trac.project-builder.org
Source0:    ftp://ftp.project-builder.org/src/%{upstream_name}-%{upstream_version}.tar.gz
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch:  noarch
Source44: import.info

%description
ProjectBuilder is a perl module providing set of functions to help develop
packages for projects and deal with different Operating systems (Linux
distributions, Solaris, ...).  It implements a Continuous Packaging approach.

%description -l fr
perl-ProjectBuilder est un ensemble de fonctions pour aider à développer 
des projets perl et à traiter de diverses distributions Linux.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor destdir=${RPM_BUILD_ROOT}/ SYSCONFDIR=%{_sysconfdir}/pb CONFDIR=%{_datadir}/pb MANDIR=%{_mandir}
make

%install
%makeinstall_std

%check
make test

%files
%doc AUTHORS COPYING ChangeLog INSTALL  NEWS README
%config(noreplace) %{_sysconfdir}/pb
%config %{_datadir}/pb/*
%{perl_vendor_privlib}/ProjectBuilder
%{_bindir}/pbdistrocheck
%{_bindir}/pbgetparam
%{_mandir}/man1/*
%{_mandir}/man5/*


%changelog
