# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/MakeMaker/CPANfile.pm) perl(Log/Any.pm) perl(Test2/V0.pm) perl(URI/Encode.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Protocol-Sys-Virt
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 11.1.0
Release: alt1
Summary: Transport independent implementation of the remote LibVirt protocol
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EH/EHUELS/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This distribution implements the mechanics of the LibVirt
protocol. With it, client and server components can be built, although it's
unlikely anyone would want to build a LibVirt compatible server.

Rationale behind the creation of this distribution is that it allows for the
imlpementation of a truely asynchronous interface to LibVirt; a property
the Sys::Virt manpage doesn't have, even when using its event loop integration.  After
having implemented the Sys::Virt::IO::Async manpage, the invocations to the methods in
`Sys::Virt' turned out to be blocking regardless.  The LibVirt
development team explained this is by design.  The solution in e.g. Python is
to use threading (the same solution as used with Python): the underlying
protocol and handling on the server is asynchronous, but the API calls are not.
Unfortunately, in Perl, threading isn't a viable option: first of all because
using Perl threads is highly discouraged, but more so because each thread
creates its own Perl interpreter with its own copies of all variables -- a
clear difference with Python, where a single interpreter is used for all
threads, sharing variables and values.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod CHANGES
%perl_vendor_privlib/P*

%changelog
