# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/MixedColor.pm) perl(Module/Load/Conditional.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(MooseX/Storage.pm) perl(Puppet/DB.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_name Puppet-Classify
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Connects to the Puppet Classifier API (PE Console groups)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MQ/MQTECH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module interacts with the Puppet Classifier API (i.e. Puppet Enterprise Console Classification groups)

    use Puppet::Classify;

    # Create a Puppet classification object
    my $classify = Puppet::Classify->new( 
                                          cert_name       => $config->{puppet_classify_cert},
                                          server_name     => $config->{puppet_classify_host},
                                          server_port     => $config->{puppet_classify_port},
                                          puppet_ssl_path => $config->{puppet_ssl_path},
                                          puppet_db       => $puppet_db,
                                        );
    # Get a group's rule
    my $rule = $classify->get_group_rule( $group_name );

    # Convert the rule for use with the PuppetDB
    $rule = $classify->convert_rule_for_puppetdb( $rule );

It requires the *Puppet::DB* module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README README.mkdn LICENSE
%perl_vendor_privlib/P*

%changelog
