# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(Hash/Flatten.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/MixedColor.pm) perl(Module/Load/Conditional.pm) perl(Moose.pm) perl(Moose/Exporter.pm) perl(MooseX/Storage.pm) perl(Puppet/Classify.pm) perl(Puppet/DB.pm) perl(YAML.pm) perl(YAML/XS.pm)
# END SourceDeps(oneline)
%define module_name Puppet-Orchestrator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Connects to the Puppet Orchestrator API (i.e. Puppet Tasks)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MQ/MQTECH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module interacts with the Puppet Orchestrator API (i.e. Puppet Tasks)

    use Puppet::DB;
    use Puppet::Orchestrator;
    use Puppet::Classify;

    # Create a Puppet DB object
    my $puppet_db = Puppet::DB->new(
        server_name => $config->{puppetdb_host},
        server_port => $config->{puppetdb_port},
    );

    # Create a Puppet classification object
    my $classify = Puppet::Classify->new(
                      cert_name       => $config->{puppet_classify_cert},
                      server_name     => $config->{puppet_classify_host},
                      server_port     => $config->{puppet_classify_port},
                      puppet_ssl_path => $config->{puppet_ssl_path},
                      puppet_db       => $puppet_db,
                    );

    # Create a Puppet orchestrator object
    my $orchestrator = Puppet::Orchestrator->new( 
                                          cert_name       => $config->{puppet_orch_cert},
                                          server_name     => $config->{puppet_orch_host},
                                          server_port     => $config->{puppet_orch_port},
                                          puppet_ssl_path => $config->{puppet_ssl_path},
                                          puppet_db       => $puppet_db,
                                        );

    $group = "All Nodes";
    my $nodes = $classify->get_nodes_matching_group( $group );
    my $jobid = $orchestrator->submit_task( "profile::check_id", { "id" => "836" }, $nodes );

    $orchestrator->print_output_wait($jobid);

It requires the *Puppet::DB* module. The *Puppet::Classify* is recommended as it allows
looking up group membership.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.mkdn README
%perl_vendor_privlib/P*

%changelog
