%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/testlib.pm) perl(Fcntl.pm) perl(MLDBM.pm) perl(Puppet/Body.pm) perl(Puppet/Log.pm) perl(Tk.pm) perl(Tk/ErrorDialog.pm) perl(Tk/Multi/Manager.pm) perl(Tk/Multi/Text.pm) perl(Tk/Multi/Toplevel.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.007
%define module_name Puppet-Show
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.007
Release: alt1
Summary: Optional Tk Gui for Puppet::Body
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DD/DDUMONT/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Puppet::Show is a utility class that is used (and not inherited like
the deprecated Puppet::Any) to manage a the Puppet::Body manpage class through
an optional GUI.

So when you construct a Puppet::Show object, you have all the
functionnality of this object without the GUI. Then, when the need
arises, you may (or the user class may decide to) open the GUI of
Puppet::Show so the user may perform any interactive action.

On the other hand, if the need does not arise, you may instanciate a lot of 
objects (which uses Puppet::Show) without cluttering your display.

The user class may use the Puppet::Show Tk widget (actually a
Tk::Multi::Toplevel widget) and add its own widget to customize the
GUI to its needs.

This class features :

=over 4

=item *

A the Tk::Multi::Toplevel manpage to show or hide the different display of the
Show class (or of the user class)

=item *

A menu bar (part of the Tk::Multi::Toplevel manpage)

=item *

An online help (part of the Tk::Multi::Toplevel manpage)

=item *

An event log display so user object may log their activity (See the Puppet::Log manpage)

=item *

A Debug log display so user objects may log their "accidental"
activities (See the Puppet::Log manpage)

=item *

An Object Scanner (See the Tk::ObjScanner manpage) to display the attributes of
the user object

=item *

A set of functions to manage "has-a" relationship between Puppet
objects.  (See the Puppet::Body manpage).  The menu bar feature a "content" bar
which enabled the user to open the display of all "contained" objects.

=item *

A facility to store data on a database file tied to a hash. (part of
the Puppet::Body manpage)

=back
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*

%changelog
