%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Accessor.pm) perl(ExtUtils/MakeMaker.pm) perl(Memoize.pm) perl(Number/Fraction.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Quantum-ClebschGordan
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Calculate/list Clebsch-Gordan Coefficients
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAVIDRW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Calculate Clebsch-Gordan coefficients.

Commandline utility:

    [davidrw@devbox davidrw]$ cg-j1j2 1 1/2

From perl:

    use Quantum::ClebschGordan;

    print Quantum::ClebschGordan->new( j1=>1, j2=>'1/2', m=>'3/2', m1=>'1', m2=>'1/2', j=>'3/2' )->coeff;

    my $foo = Quantum::ClebschGordan->new();
    ...
    printf "%%6s %%6s %%6s %%6s %%6s %%6s %%6s, %%s\n", Quantum::ClebschGordan->state_names, 'N', 'c';
    printf "%%6s %%6s %%6s %%6s %%6s %%6s %%6s, %%s\n", $_->state_nums, $_->coeff, $_->coeff_value
      for Quantum::ClebschGordan->new( j1 => 1, j2 => '1/2' )->explode;

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc TODO README Changes
%perl_vendor_privlib/Q*

%files scripts
%_bindir/*

%changelog
