%define module_version 0.31
%define module_name Queue-Q
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/XSAccessor.pm) perl(Digest/MD5.pm) perl(Digest/SHA1.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(JSON/XS.pm) perl(List/Util.pm) perl(Redis.pm) perl(Redis/ScriptCache.pm) perl(Scalar/Util.pm) perl(Sereal/Decoder.pm) perl(Sereal/Encoder.pm) perl(Term/ReadLine.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(constant.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.31
Release: alt1
Summary: Mix-and-match Queue Implementations and Backends
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MATTK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is an experimental module. The interface may change without notice.
Before using it in production, please get in touch with the authors!

`Queue::Q' is a collection of queue implementations each with multiple backends.
Right now, it comes with three basic queues:

=over 2

=item the Queue::Q::NaiveFIFO manpage

A naive FIFO queue `NaiveFIFO'. Supports enqueuing data and later claiming
it in the order it was enqueued. Strict ordering, low-latency, high-throughput,
no resilience against crashing workers.

=item the Queue::Q::ClaimFIFO manpage

A claim/mark-as-done FIFO queue `ClaimFIFO'. Supports enqueuing data
(as the Queue::Q::ClaimFIFO::Item manpage objects), claiming items, and keeping
track of items-being-worked-on until they are reported as done.
Strict ordering, slightly higher latency and lower throughput than the
naive FIFO queue. Resilience against crashing workers when combined with
a clean-up script that checks for old, claimed items.

=item the Queue::Q::ReliableFIFO manpage

Similar interface to the `ClaimFIFO' queue type, but only comes with a
Redis-backed implementation now. Much faster for the basic operations
then `ClaimFIFO' since it doesn't always have to execute Lua scripts.
See the Queue::Q::ReliableFIFO manpage for details.

=back

The first two basic queues come with two back-end implementations each right now:
One is a very simple, in-memory, single-process implementation the Queue::Q::NaiveFIFO::Perl manpage
and the Queue::Q::ClaimFIFO::Perl manpage respectively. The other is an implementation
based on Redis: the Queue::Q::NaiveFIFO::Redis manpage and  the Queue::Q::ClaimFIFO::Redis manpage.

As noted above, the `ReliableFIFO' queue has a Redis-based backend only for now.

In addition to the basic queue types, the distribution contains
the Queue::Q::DistFIFO manpage, an implementation of a distributed queue
that can use the basic queues as shards (but only one type of shard per
distributed queue). It supports all operations of the basic queues, but
does not enforce strict global ordering, but weak global and strict local
ordering. In an early test, two mid-range servers running multiple instances
of Redis each sustained 800k-1M transactions per second with a naive-type
distributed queue. `DistFIFO' has not been tested with the `ReliableFIFO'
implementation as building blocks yet!

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/Q*

%files scripts
%_bindir/*

%changelog
