%add_findreq_skiplist */RDF/Core/Enumerator/DB_File.pm
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/Pg.pm) perl(DBI.pm) perl(DB_File.pm) perl(Exporter.pm) perl(URI.pm) perl(XML/Parser.pm)
# END SourceDeps(oneline)
%define module_version 0.51
%define module_name RDF-Core
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.51
Release: alt1
Summary: An object oriented Perl modules for handling tasks related to RDF.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DP/DPOKORNY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch
Patch: RDF-Core-0.51-syntax.patch

%description
RDF::Core has these parts:

=over 4

=item * RDF::Core::Model

Model provides interface to store RDF statements, ask about them and retrieve them back.

=item * RDF::Core::Constants

Defines usefule constants for the RDF processing like namespaces etc.

=item * RDF::Core::Parser

Generates statements from an RDF XML document.

=item * RDF::Core::Model::Parser

Model::Parser is a simple interface object to a parser. It's purpose is to provide a prototype of object accomodating any other parser.

=item * RDF::Core::Serializer

Serializes RDF Model into XML.

=item * RDF::Core::Model::Serializer

Model::Serializer is an interface object for Serializer.

=item * RDF::Core::Storage

An object for storing statements. There are several implementations of Storage - in memory, in a BerkeleyDB 1.x (DB_File) files and PostgreSQL database.

=item * RDF::Core::Enumerator

Enumerator is a result set of statements retrieved from Model

=item * RDF::Core::Query

An implementation of query language.

=item * RDF::Core::Schema

The RDF Schema utilities.

=item * Basic elements

RDF::Core::Statement, RDF::Core::Resource, RDF::Core::Literal, RDF::Core::Node

=back

%prep
%setup -q -n %{module_name}-%{module_version}
%patch -p1

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes doc
%perl_vendor_privlib/R*

%changelog
