# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(RDF/Query.pm) perl(RDF/Query/Error.pm) perl(RDF/Trine/Namespace.pm) perl(RDF/TrineX/Functions.pm) perl(Socket.pm) perl(Test/More.pm) perl(base.pm) perl(inc/Module/Package.pm) perl(overload.pm) perl(utf8_heavy.pl)
# END SourceDeps(oneline)
%define module_version 0.002
%define module_name RDF-Query-Functions-Buzzword-GB
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: plugin for buzzword.org.uk British locale-specific functions
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/RDF-Query-Functions-Buzzword-GB

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a plugin for RDF::Query providing a number of extension functions.

=over

=item * http://buzzword.org.uk/2011/functions/gb#postcode_valid

Given a literal, returns a boolean indicating whether it seems to be
a syntactically valid UK postcode.

=item * http://buzzword.org.uk/2011/functions/gb#postcode_format

Given a literal, if it seems to be a valid UK postcode, canonicalises
the formatting; otherwise returns the literal unscathed.

=item * http://buzzword.org.uk/2011/functions/gb#telephone_valid

Given a literal, returns a boolean indicating whether it seems to be
a number that could be dialed from a UK phone.

Only the digits '0' to '9', letter 'x' (extension) and '+' (international
dialing code) are expected. Other characters are stripped out before any
checks.

=item * http://buzzword.org.uk/2011/functions/gb#telephone_format

Canonicalises the formatting of a phone number that is valid. Should return
invalid phone numbers unscathed.

=item * http://buzzword.org.uk/2011/functions/gb#telephone_std

Returns the STD code for a phone number, if it could be extracted; the
empty string otherwise.

=item * http://buzzword.org.uk/2011/functions/gb#telephone_local

Returns the local part of a phone number, if it could be extracted; the
empty string otherwise.

=item * http://buzzword.org.uk/2011/functions/gb#telephone_extension

Returns the extension from a phone number, if it could be extracted; the
empty string otherwise.

=item * http://buzzword.org.uk/2011/functions/gb#telephone_uri

Returns a phone number as a <tel:> URI.

An existing <tel:> URI should pass through unscathed.

=back

=begin trustme

=item `install'

=end trustme


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README TODO examples
%perl_vendor_privlib/R*

%changelog
