# BEGIN SourceDeps(oneline):
BuildRequires: perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name REST-Buildbot
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Interface to the Buildbot v2 REST API
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCOLLINS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is an interface to the REST API provided by Buildbot instances. Most
object types can be fetched by name or id, and most object types can be
used to look up associated objects. The individual objects have no methods,
but do have accessors for all of the data returned by the REST API. Most
attributes are pure perl data types, the only exception is BuildSets and
Changes, both of which have an attribute that contains a
REST::BuildBot::SourceStamp or an arrayref of them.

    use REST::Buildbot;

    my $bb = REST::Buildbot->new(url => 'http://localhost:8010/api/v2/');

    # Get the 'linux' builder's first build
    my $linux_builder = $bb->get_builder_by_name('linux');
    my $build = $bb->get_build_by_builder_and_number($linux_builder, 1);

    # Learn about this build
    my $buildrequest = $bb->get_buildrequest_by_id($build->buildrequestid);
    my $buildset = $bb->get_buildset_by_id($buildrequest->buildsetid);
    my $sourcestamp = $buildset->sourcestamps->[0];
    # Branch, revision ID, and commit message are in the SourceStamp object

    # Look up all the builds with a certain revision
    my $rev = '0123456789abcdef...';
    my $buildsets = $bb->get_buildsets_by_revision($rev);
    # There may be several, choose in your own way
    my $buildset = $buildsets->[0];
    # Find all the builds on this buildset, and explore some information
    my $buildrequests = $bb->get_buildrequests_by_buildset($bsid);
    foreach my $buildrequest (@$buildrequests) {
        my $brid = $buildrequest->buildrequestid;
        my $builds = $bb->get_builds_by_buildrequest($brid);
        # Again, choose one build. Usually most recent, older ones may
        # be cancels or retries
        my $build = $builds->[0];
        my $steps = $bb->get_steps_by_build($build->buildid);
        # The last step is make test for me
        my $make_test = $steps->[-1];
        my $logs = $bb->get_logs_by_step($make_test->stepid);
        # Choose which log to use - probably by looping and
        # comparing against name
        m...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
