%define _without_test 1
%define module_version 0.8
%define module_name RPM-Tools
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.8
Release: alt1
Summary: cleanly generate an RPM
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHARRISON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Automatically generate an RPM software package from a list of files.

RPM::Make builds the RPM in a very clean and configurable fashion.
(Finally!  Making RPMs outside of /usr/src/redhat without a zillion
file intermediates left over!)

RPM::Make should work with both rpm 3.x and rpm 4.x (it has been tested
on redhat 6.x, redhat 7.x, and redhat 8.x as well as other un*x variants).

RPM::Make generates and then deletes temporary
files needed to build an RPM with.
It works cleanly and independently from pre-existing
directory trees such as /usr/src/redhat/*.

RPM::Make accepts five kinds of
information, three of which are significant:

=over 4

=item *

(significant) a list of files that are to be part of the software package;

=item *

(significant) the filesystem location of these files;

=item *

(significant) a descriptive tag and a version tag for the naming of the
RPM software package;

=item *

documentation and configuration files;

=item *

and additional metadata associated with the RPM software package.

=back

When using RPM::Make::execute, a temporary directory named $buildloc is

=over 4

=item *

generated under the directory from which you run your script;

=item *

then deleted after the *.rpm file is generated.

=back

The RPM will typically be named
"$metadata{'name'}-$version-$release.i386.rpm".
If $metadata{'name'} is not specified, then $tag is used.

Here are some of the items that are generated inside
the $buildloc directory during the construction of an RPM:

=over 4

=item *

RPM .spec file (./$buildloc/SPECS/$name-$version.spec)

=item *

RPM Makefile (./$buildloc/SOURCES/$name-$version/Makefile)

This is the Makefile that is called by the rpm
command in building the .i386.rpm from the .src.rpm.
The following directories are generated and/or used:

=over 4

=item *

SOURCE directory: ./$buildloc/BinaryRoot/

=item *

TARGET directory: ./$buildloc/BuildRoot/

=back

=item *

BinaryRootMakefile (./$buildloc/BinaryRootMakefile)

This is the Makefile that this script creates and calls
to build the $buildloc/BinaryRoot/ directory from the existing
filesystem.
The following directories are generated and/or used:

=over 4

=item *

SOURCE directory: / (your entire filesystem)

=item *

TARGET directory: ./$buildloc/BinaryRoot/

=back

=back

The final output of RPM::Make::execute is a binary .rpm file.
The ./buildloc directory is deleted (along with the .src.rpm
file).  The typical file name generated by RPM::Make is
$tag-$version-$release.i386.rpm.

RPM::Make is compatible with either rpm version 3.* or rpm version 4.*.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ChangeLog
%perl_vendor_privlib/R*

%changelog
