# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Html.pm) perl(Pod/Man.pm) perl(Pod/Text.pm) perl(RT.pm) perl(RT/Action.pm) perl(RT/System.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name RT-Extension-CustomerGroups
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Make RT operate on "customers" not individual accounts
Group: Development/Perl
License: perl
URL: https://github.com/2ndQuadrant/rt-extension-customergroups-perl

Source0: http://cpan.org.ua/authors/id/R/RI/RINGERC/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
RT::Extension::CustomerGroups is designed to give RT the concept of a
"customer" entity, a collection of one or more user accounts who should all
share access to the same tickets and all be notified about the same events.
It's designed to limit the amount of maintenance required when managing groups
of contacts by ensuring that contacts that're newly added to a customer are
automatically given access to the customer's history.

This is a workaround for RT's lack of a two-level account entity like a
"customer" that has-many "contacts". We use RT users as contacts, and designate
select groups as "customer" entities. *If RT's lack of multiple email addresses
per user is driving you insane, this module is designed to help*.

When tickets are created or users are added to a ticket as Requestor/Cc/Admincc
and the user in question is a member of one or more customer group(s) the user
entry is replaced by the customer group(s) found. So if "bob@example.com"
submits a ticket his Requestor entry will be replaced with an entry for the
customer group "customer-ExampleDotCom" . If the user is a member of more than
one customer group all will be added.

It is recommended that the customer contacts be given unprivileged accounts,
and all privileges the customer should have be assigned to the group they're a
member of. Since individual users will get replaced by groups using unprivileged
users will avoid confusion caused when not all users in the group have the same
rights. The extension will work fine with privileged users, you might just have
to think about your granted rights a little more.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/R*

%changelog
