%define module_name RTx-ToGitHub
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Carp.pm) perl(Data/Dumper/Concise.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Prompt/Tiny.pm) perl(IPC/System/Simple.pm) perl(LWP/ConsoleLogger.pm) perl(List/AllUtils.pm) perl(Moo.pm) perl(MooX/Options.pm) perl(Path/Tiny.pm) perl(Pithub.pm) perl(RT/Client/REST.pm) perl(RT/Client/REST/Ticket.pm) perl(RT/Client/REST/User.pm) perl(Search/Elasticsearch.pm) perl(Specio/Declare.pm) perl(Specio/Library/Builtins.pm) perl(Specio/Library/Numeric.pm) perl(Specio/Library/Perl.pm) perl(Specio/Library/String.pm) perl(Test/More.pm) perl(Try/Tiny.pm) perl(URI/Escape.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Convert rt.cpan.org tickets to GitHub issues
Group: Development/Perl
License: apache
URL: https://metacpan.org/release/RTx-ToGitHub

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DROLSKY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a tool to convert RT tickets to GitHub issues. When you run it, it
will:

=over 4

=item 1. Prompt you for any info it needs

Run with `--no-prompt' to disable prompts, in which case it will either use
the command line options you provide or look in various config files and `git
config' for needed info.

=item 2. Make GitHub issues for each RT ticket

The body of the ticket will be the new issue body, with replies converted to
comments. Requestors and others participating in the discussion will be
converted to `@username' mentions on GitHub. The conversion is based on a
one-time data dump made by pulling author data from MetaCPAN to make an email
address to GitHub username map. Patches to this map are welcome.

Only tickets with the "new", "open", or "stalled" status are
converted. Stalled tickets are given a "stalled" label on GitHub.

=item 3. Close the RT ticket

Unless you pass the `--no-resolve' option.

=back

=for Pod::Coverage .*

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CODE_OF_CONDUCT.md CONTRIBUTING.md README.md Changes LICENSE
%perl_vendor_privlib/R*

%files scripts
%_bindir/*

%changelog
