%define module_version 1.19
%define module_name RackMan
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Algorithm/Diff.pm) perl(CGI.pm) perl(Carp.pm) perl(Config/IniFiles.pm) perl(Cwd.pm) perl(DBD/mysql.pm) perl(DBIx/Class.pm) perl(DBIx/Class/Schema/Loader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(HTML/Template.pm) perl(HTML/Template/Filter/TT2.pm) perl(IPC/Run.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(List/MoreUtils.pm) perl(Module/Build.pm) perl(Module/Runtime.pm) perl(Moose.pm) perl(MooseX/NonMoose.pm) perl(Net/FTP.pm) perl(Net/ILO.pm) perl(Net/SNMP.pm) perl(Net/Telnet/Cisco.pm) perl(NetAddr/IP.pm) perl(Path/Class.pm) perl(Pod/Usage.pm) perl(Socket.pm) perl(Socket6.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(YAML.pm) perl(YAML/XS.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.19
Release: alt1
Summary: Main interface for accessing a RackTables database
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SA/SAPER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
RackMan is a set of Perl modules for fetching information from a
RackTables database. The distribution
also includes some commands that show how to use the RackMan API.

=over 

=item *
rack is a program that generates the configuration files for the
given RackObject, and talk with the corresponding devices to set
them up accordingly.

=item *
cisco-status is a program that connects to a Cisco switch to list
the devices connected to it, with additionnal information resolved
from RackTables.

=item *
cfengine-tags is a program that generates tag files for Cfengine.

=back
    
A technical presentation of this software was made at the French
Perl Workshop 2012: http://maddingue.org/conferences/fpw-2012/rackman/

Note: This software was written to perform very specific tasks.
Although it was tried to keep it generic, it certainly isn't, and
the documentation is very rough. There's a more comprehensive
tutorial (only in French for now) in pod/RackMan/Manual.fr.pod

This `RackMan' module provides the main interface for accessing a
RackTables database.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name



%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/R*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
