%define module_version 0.03
%define module_name Rand-Urandom
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: replaces rand() with /dev/urandom
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BA/BADALEX/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
http://sockpuppet.org/blog/2014/02/25/safely-generate-random-numbers/

Perl's built-in rand has a few problems:

=over

=item *
the state is inherited across fork(), meaning its real easy to generate/use the
same "random" number twice. Especially when using mod_perl. Yes I've been
bitten by this before.

=item *
per perldoc "rand()" is not cryptographically secure. You should not rely on it in security-sensitive situations."

=item *
seeding is hard to get right

=back

By default it uses the getentropy() (only available in > Linux 3.17) and falls
back to /dev/arandom then /dev/urandom. Otherwise it dies.

This means it should "DoTheRightThing" on most unix based systems, including,
OpenBSD, FreesBSD, Mac OSX, Linux, blah blah.

You: *Yeah, Ok I see you're point, but do I actually want to use this?*

Me: Maybe!, It could also be a really bad idea!
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/R*

%changelog
