# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Random-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.24
Release: alt1
Summary: Generate good random numbers in a user consumable way.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BA/BAKERSCOT/%{module_name}-%{version}.tar.gz

%description
Perl's internal `rand()' function uses `drand48' which is an older
pseudorandom number generator and may have limitations. `Random::Simple' uses
PCG which is: modern, simple, well vetted, and fast. Using `Random::Simple'
will automatically upgrade/override the core `rand()' function to use a
better PRNG.

`Random::Simple' is automatically seeded with entropy directly
from your OS. On Linux this is `/dev/urandom' and on Windows it uses
RtlGenRandom.

When you `use Random::Simple' we automatically upgrade `rand()' and `srand()'
to use a modern PRNG with better statistical properties. As a bonus you also
get a handful of other useful random related methods.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE README.md release-notes.md
%perl_vendor_archlib/R*
%perl_vendor_autolib/*

%changelog
